/*
 * Decompiled with CFR 0.152.
 */
package com.android.print.sdk.util;

import android.graphics.Bitmap;
import android.util.Log;
import com.android.print.sdk.util.DataConversion;
import com.android.print.sdk.util.MdUtils;
import java.util.Vector;

public class Command {
    public Vector<Byte> Command = new Vector();
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private void addArrayToCommand(byte[] array) {
        int i = 0;
        while (i < array.length) {
            this.Command.add(array[i]);
            ++i;
        }
    }

    public Command addBitImage(Bitmap bitmap) {
        return this.addRastBitImage(bitmap, bitmap.getWidth(), 0);
    }

    public Command addRastBitImage(Bitmap bitmap, int nWidth, int nMode) {
        if (bitmap != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap grayBitmap = MdUtils.toGrayscale(bitmap);
            Bitmap rszBitmap = MdUtils.resizeImage(grayBitmap, width, height);
            byte[] src = MdUtils.bitmapToBWPix(rszBitmap);
            byte[] command = new byte[8];
            height = src.length / width;
            command[0] = 29;
            command[1] = 118;
            command[2] = 48;
            command[3] = (byte)(nMode & 1);
            command[4] = (byte)(width / 8 % 256);
            command[5] = (byte)(width / 8 / 256);
            command[6] = (byte)(height % 256);
            command[7] = (byte)(height / 256);
            this.addArrayToCommand(command);
            byte[] codecontent = MdUtils.pixToEscRastBitImageCmd(src);
            int k = 0;
            while (k < codecontent.length) {
                this.Command.add(codecontent[k]);
                ++k;
            }
        } else {
            Log.d((String)"BMP", (String)"bmp.  null ");
        }
        return this;
    }

    public byte[] getCommand() {
        Byte[] Bytes = this.Command.toArray(new Byte[this.Command.size()]);
        byte[] bytes = com.android.print.sdk.util.Command.toPrimitive(Bytes);
        return bytes;
    }

    public Command addApplication(byte[] fileByte) {
        byte[] lenByte = DataConversion.intToByte4(fileByte.length);
        lenByte = DataConversion.invertArray(lenByte);
        int sum = DataConversion.checkSum(fileByte);
        byte[] sumByte = DataConversion.intToByte4(sum);
        sumByte = DataConversion.invertArray(sumByte);
        this.addArrayToCommand(new byte[]{27, 35, 35, 85, 80, 80, 71});
        this.addArrayToCommand(sumByte);
        this.addArrayToCommand(lenByte);
        this.addArrayToCommand(fileByte);
        return this;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }
}

